<?php
header('Content-Type: application/json; charset=utf-8');

$url = 'https://giftcharts-api.onrender.com/gifts';
$q = isset($_GET['q']) ? trim($_GET['q']) : '';

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

if ($response === false) {
    http_response_code(500);
    echo json_encode(['خطأ' => 'خطأ في جلب البيانات'], JSON_UNESCAPED_UNICODE);
    exit;
}

$gifts = json_decode($response, true) ?? [];

if ($q !== '') {
    $gifts = array_filter($gifts, fn($gift) => stripos($gift['name'], $q) !== false);
}

$gifts = array_map(fn($gift) => [
    'المعرّف' => $gift['_id'],
    'الاسم' => $gift['name'],
    'المخزون' => $gift['supply'],
    'المخزون الأولي' => $gift['initSupply'],
    'تاريخ الإصدار' => $gift['releaseDate'],
    'سعر النجوم' => $gift['starsPrice'],
    'سعر الترقية' => $gift['upgradePrice'],
    'سعر TON الأولي' => $gift['initTonPrice'],
    'سعر الدولار الأولي' => $gift['initUsdPrice'],
    'المخزون بعد الترقية' => $gift['upgradedSupply'],
    'سعر TON قبل 24 ساعة' => $gift['tonPrice24hAgo'],
    'سعر الدولار قبل 24 ساعة' => $gift['usdPrice24hAgo'],
    'سعر TON قبل أسبوع' => $gift['tonPriceWeekAgo'],
    'سعر الدولار قبل أسبوع' => $gift['usdPriceWeekAgo'],
    'سعر TON قبل شهر' => $gift['tonPriceMonthAgo'],
    'سعر الدولار قبل شهر' => $gift['usdPriceMonthAgo'],
    'سعر TON الحالي' => $gift['priceTon'],
    'سعر الدولار الحالي' => $gift['priceUsd'],
], $gifts);

$output = [
    'المطور' => '@Alireza_Haji',
    'gifts' => array_values($gifts)
];

echo json_encode($output, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);